//
// NiestandardowaKlasaWyjatku — demonstruje elastyczność
// mechanizmu obsługi wyjątków, poprzez utworzenie
// niestandardowej klasy wyjątków
//
#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <sstream>
using namespace std;
// MojWyjatek - ogólna klasa obsługi wyjątków
class MojWyjatek
{
  public:
    MojWyjatek(const char* pWiad, int n,
               const char* pFunc,
               const char* pPlik, int nWiersz)
        : wiad(pWiad), wartoscBledu(n),
          nazwaFunkcji(pFunc), plik(pPlik), numerWiersza(nWiersz){}
    virtual string wyswietl()
    {
        ostringstream out;
        out << "Błąd <" << wiad << ">"
            << " - wartość wynosi  " << wartoscBledu << "\n"
            << "w funkcji " << nazwaFunkcji << "()\n"
            << "w pliku " << plik
            << " w wierszu #" << numerWiersza << ends;
        return out.str();
    }
  protected:
    // Komunikat o błędzie
    string wiad;
    int wartoscBledu;
    // nazwa funkcji, nazwa pliku i
    // numer wiersza, w których wystąpił błąd
    string nazwaFunkcji;
    string plik;
    int numerWiersza;
};
// silnia – oblicz silnię
int silnia(int n) throw(MojWyjatek)
{
    // nie możesz obsłużyć ujemnych wartości n;
    // lepiej najpierw sprawdź ten warunek
    if (n < 0)
    {
        throw MojWyjatek("Ujemny argument jest niedozwolony",
                        n, __func__, __FILE__, __LINE__);
    }
    // oblicz silnię
    int akumulator = 1;
    while(n > 0)
    {
        akumulator *= n;
        n--;
    }
    return akumulator;
}
int main(int nLiczbaArgumentow, char* pszArgs[])
{
    try
    {
        // ta instrukcja będzie działać
        cout << "Silnia 3 wynosi "
             << silnia(3) << endl;
        // ta instrukcja spowoduje wygenerowanie wyjątku
        cout << "Silnia -1 wynosi "
             << silnia(-1) << endl;
        // sterowanie nigdy tu nie dotrze
        cout << "Silnia 5 wynosi "
             << silnia(5) << endl;
    }
    // sterowanie przejdzie tutaj
    catch(MojWyjatek e)
    {
        cout << e.wyswietl() << endl;
    }
    catch(...)
    {
        cout << "Przechwycono domyślny wyjątek" << endl;
    }
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
