// PrzykładDziedziczenia — demonstruje relację
// dziedziczenia, w której konstruktor podklasy
// przekazuje argumenty do konstruktora
// klasy bazowej
//
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;
class Doradca {}; // zdefiniuj pustą klasę
class Student
{
  public:
    Student(const char *pImie = "bez imienia")
        : imie(pImie), srednia(0.0), godzinySemestru(0)
    {
        cout << "Tworzenie studenta " << imie << endl;
    }
    void dodajKurs(int godziny, float ocena)
    {
        cout << "Dodawanie oceny do " << imie << endl;
        srednia = godzinySemestru * srednia + ocena;
        godzinySemestru += godziny;
        srednia = srednia / godzinySemestru;
    }
    int godziny() { return godzinySemestru; }
    float gpa() { return srednia; }
  protected:
    string imie;
    double srednia;
    int godzinySemestru;
};
class Doktorant : public Student
{
  public:
    Doktorant(const char *pImie, Doradca dor,
              double qG = 0.0)
        : Student(pImie), doradca(dor), ocenaKoncowa(qG)
    {
        cout << "Konstruowanie doktoranta "
             << pImie << endl;
    }
    double zaliczenie() { return ocenaKoncowa; }
  protected:
    Doradca doradca;
    double ocenaKoncowa;
};
int main(int nLiczbaArgumentow, char* pszArgs[])
{
    // stwórz fikcyjnego doradcę dla doktoranta
    Doradca dor;
    // utwórz studentów dwóch typów
    Student llu("Andrzej Nowak");
    Doktorant d("Adam Kowal", dor, 1.5);
    // teraz dodaj ocenę do średniej ocen
    llu.dodajKurs(3, 2.5);
    d.dodajKurs(3, 3.0);
    // wyświetlić ocenę końcową doktoranta
    cout << "Ocena końcowa Adama = "
         << d.zaliczenie() << endl;
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
