// STLString — demonstruje kilka funkcji
// klasy string, która jest częścią
// standardowej biblioteki szablonów
#include <cstdlib>
#include <cstdio>
#include <iostream>
using namespace std;
// usunSpacje - usuń spacje w ciągu znaków
string usunSpacje(const string& zrodlo)
{
    // utwórz kopię źródłowego obiektu,
    // aby go nie modyfikować
    string s = zrodlo;
    // znajdź przesunięcie pierwszej spacji;
    // przeszukuj ciąg, aż nie znajdziesz więcej spacji
    size_t offset;
    while((offset = s.find(" ")) != string::npos)
    {
        // usuń znalezioną spację
        s.erase(offset, 1);
    }
    return s;
}
// wstawFraze — wstaw frazę w miejscu
// gdzie znajduje się <p>
string wstawFraze(const string& zrodlo)
{
    string s = zrodlo;
    size_t offset = s.find("<ip>");
    if (offset != string::npos)
    {
        s.erase(offset, 4);
        s.insert(offset, "Randall");
    }
    return s;
}
int main(int argc, char* pArgs[])
{
    // utwórz ciąg znaków będący sumą dwóch ciągów znaków
    cout << "string1 + string2 = "
         << (string("string 1") + string("string 2"))
         << endl;
    // utwórz testowy obiekt klasy string, a następnie usuń z niego
    // wszystkie spacje za pomocą prostych metod klasy string
    string s2("To jest ciąg testowy");
    cout << "<" << s2 << "> bez spacji = <"
         << usunSpacje(s2) << ">" << endl;
    // wstaw frazę w środku istniejącego
    // zdania (w miejscu w którym znajduje się "<p>")
    string s3 = "Stephen <ip> Davis";
    cout << s3 + " -> " + wstawFraze(s3) << endl;
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
