//
// MoveCopy — demonstruje użycie zasady przenoszenia
//          obiektu tymczasowego zamiast tworzenia kopii
//
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;
class Osoba
{
  public:
    Osoba(const char *pN)
    {
        pImie = new string(pN);
        cout << "Konstruowanie obiektu " << *pImie << endl;
    }
    Osoba(Osoba& p)
    {
        cout << "Kopiowanie obiektu " << *p.pImie << endl;
        pImie = new string("Kopia ");
        *pImie += *p.pImie;
    }
    Osoba(Osoba&& p)
    {
        cout << "Przenoszenie obiektu " << *p.pImie << endl;
        pImie = p.pImie;
        p.pImie = nullptr;
    }
    ~Osoba()
    {
        if (pImie)
        {
            cout << "Niszczenie obiektu " << *pImie << endl;
            delete pImie;
        }
        else
        {
            cout << "Niszczenie obiektu null" << endl;
        }
    }
  protected:
    string* pImie;
};
Osoba fn2(Osoba p)
{
    cout << "Wejście do funkcji fn2" << endl;
    return p;
}
Osoba fn1(char* pImie)
{
    cout << "Wejście do funkcji fn1" << endl;
    return fn2(*new Osoba(pImie));
}
int main(int nLiczbaArgumentow, char* pArgs[])
{
    Osoba s(fn1("Jacek"));
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
