// AccountLinkedList - utrzymuje listę obiektów

#ifndef _ACCOUNTLINKEDLIST_
#define _ACCOUNTLINKEDLIST_

template <class T> class LinkedList;

// Node - węzeł na liście; każdy węzeł wskazuje na obiekt typu Account
template <class T> class Node
{
    public:
        Node(LinkedList<T>* pL, T* pT)
        {
            pList = pL;
            pNext = 0;
            pObject = pT;
        }

        Node<T>* next() { return pNext; }
        Node<T>* next(Node<T>* pN) { pNext = pN; return pNext; }
        T* current() { return pObject; }

    protected:
        LinkedList<T>* pList;
        Node<T>* pNext;
        T* pObject;
};

// LinkedList - reprezentuje listę
template <class T> class LinkedList
{
    public:
        LinkedList<T>() { pFirst = 0; }
        Node<T>* firstNode() { return pFirst; }
        Node<T>* lastNode()
        {
            // jeśli lista jest pusta, zwróć zero
            if (pFirst == 0)
            {
                return 0;
            }

            // w przeciwnym wypadku znajdź ostatni element
            Node<T>* pN = pFirst;
            while(true)
            {
                Node<T>* pNext = pN->next();
                if (pNext == 0)
                {
                    break;
                }
                pN = pNext;
            }
            return pN;
        }

        void  addNode(Node<T>* pNode)
        {
            Node<T>* pN = lastNode();
            if (pN == 0)
            {
                pFirst = pNode;
            }
            else
            {
                pN->next(pNode);
            }
        }

    protected:
        Node<T>* pFirst;
};

#endif

