// WolajSkladoweStatyczne — demonstruje dwa sposoby wywoływania
//                    statycznej funkcji składowej
//
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;
class Student
{
  public:
    Student(const char* pN = "bez imienia") : sImie(pN)
    {
        liczbaStudentow++;
    }
    ~Student() { liczbaStudentow--; }
    const string& imie() { return sImie; }
    static int liczba() { return liczbaStudentow; }
  protected:
    string sImie;
    static int liczbaStudentow;
};
int Student::liczbaStudentow = 0;
int main(int nLiczbaArgumentow, char* pArgs[])
{
    // stwórz dwóch studentów i zapytaj klasę "ile?"
    Student s1("Krzysztof");
    Student* pS2 = new Student("Jacek");
    cout << "Stworzono obiekty " << s1.imie()
         << " i " << pS2->imie() << endl;
    cout << "Liczba studentów to "
         << s1.liczba() << endl;
    // teraz pozbądź się jednego studenta i zapytaj ponownie
    cout << "Usuwanie " << pS2->imie() << endl;
    delete pS2;
    cout << "Liczba studentów to "
         << Student::liczba() << endl;
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
