// WyjatekSilni — demonstruje  wyjątki na przykładzie
// funkcji silni
//
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;
// silnia - oblicz silnię
int silnia(int n)
{
    // nie możesz obsłużyć ujemnych wartości n;
    // lepiej najpierw sprawdzić ten warunek
    if (n < 0)
    {
        throw string("Argument podany do obliczenia silni jest ujemny");
    }
    // oblicz silnię
    int akumulator = 1;
    while(n > 0)
    {
        akumulator *= n;
        n--;
    }
    return akumulator;
}
int main(int nLiczbaArgumentow, char* pszArgs[])
{
    try
    {
        // ta instrukcja będzie działać
        cout << "Silnia 3 wynosi "
             << silnia(3) << endl;
        // ta instrukcja spowoduje zgłoszenie wyjątku
        cout << "Silnia -1 wynosi "
             << silnia(-1) << endl;
        // sterowanie nigdy tu nie dotrze
        cout << "Silnia 5 wynosi "
             << silnia(5) << endl;
    }
    // sterowanie przejdzie tutaj
    catch(string error)
    {
        cout << "Wystąpił błąd: " << error << endl;
    }
    catch(...)
    {
        cout << "Domyślna instrukcja catch " << endl;
    }
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
