// DisplayMonths - wyświetla nazwy miesięcy na podstawie
//                 indeksów w tablicy zadeklarowanej jako stała
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;

// zdefiniuj tablicę zawierającą nazwy miesięcy
const char *const pszMiesiace[] = {"niepoprawny",
                                   "styczeń",
                                   "luty",
                                   "marzec",
                                   "kwiecień",
                                   "maj",
                                   "czerwiec",
                                   "lipiec",
                                   "sierpień",
                                   "wrzesień",
                                   "październik",
                                   "listopad",
                                   "grudzień"};
// intNaMiesiac() — zwróć nazwę miesiąca
const char* intNaMiesiac(int nMiesiac)
{
    // najpierw sprawdź, czy podana wartość nie jest poza zakresem
    if (nMiesiac < 1 || nMiesiac > 12)
    {
        return pszMiesiace[0];
    }
    // nMiesiac jest prawidłowy — zwróć nazwę miesiąca
    return pszMiesiace[nMiesiac];
}

int main(int nNumberofArgs, char* pszArgs[])
{
    cout << "Wprowadź numer miesiąca\n"
         << "(Wprowadź wartosć ujemną by wyjść)" << endl;
    for(;;)
    {
        cout << "Miesiąc?";
        int nMiesiac;
        cin >> nMiesiac;
        if (nMiesiac < 0)
        {
            break;
        }

        cout << "To " << intNaMiesiac(nMiesiac) << endl;
    }

    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
