// ArrayDemo — demonstruje użycie tablic.
// Odczytuje ciąg liczb całkowitych,
// a następnie wyświetla je i ich sumę
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;
// deklaracje prototypów
int czytajTablice(int tablicaInt[], int maxElementow);
int sumujTablice(int tablicaInt[], int liczbaElementow);
void wyswietlTablice(int tablicaInt[], int liczbaElementow);
int main(int liczbaArgumentow, char* pszArgs[])
{
    // wprowadź liczbę powtórzeń pętli
    cout << "Ten program sumuje wprowadzone przez "
         << "użytownika wartości\n";
    cout << "Zakończ pętlę, "
         << "wprowadzając liczbę ujemną\n";
    cout << endl;
    // zapisz liczby do zsumowania wprowadzone przez użytkownika
    // do tablicy lokalnej
    int wartosciWejsciowe[128];
    int liczbaWartosci = czytajTablice(wartosciWejsciowe, 128);
    // teraz wyświetl wartości i sumę wartości
    wyswietlTablice(wartosciWejsciowe, liczbaWartosci);
    cout << "Suma wartości wynosi "
         << sumujTablice(wartosciWejsciowe, liczbaWartosci)
         << endl;
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
// czytajTablice — odczytaj liczby całkowite wprowadzane przez użytkownika
// do tablicy 'tablicaInt' dopóki operator nie wprowadzi wartości ujemnej.
// Zwróć liczbę przechowywanych elementów.
int czytajTablice(int tablicaInt[], int maxElementow)
{
    int liczbaWartosci;
    for(liczbaWartosci = 0;
        liczbaWartosci < maxElementow;
        liczbaWartosci++)
    {
        // pobierz następną liczbę
        int wartoscInt;
        cout << "Wprowadź następną liczbę: ";
        cin >> wartoscInt;
        // jeśli jest ujemna…
        if (wartoscInt < 0)
        {
            // …wyjdź z pętli
            break;
        }
        // …w przeciwnym razie zapisz wartość
        // do tablicy przechowującej
        tablicaInt[liczbaWartosci] = wartoscInt;
    }
    // zwróć liczbę odczytanych elementów
    return liczbaWartosci;
}
// wyswietlTablice — wyświetl elementy tablicy
void wyswietlTablice(int tablicaInt[], int liczbaElementow)
{
    cout << "Wartości przechowywane w tablicy:" << endl;
    for (int i = 0; i < liczbaElementow; i++)
    {
        cout << i << ": " << tablicaInt[i] << endl;
    }
    cout << endl;
}
// sumujTablice — zwraca sumę elementów tablicy
//               liczb całkowitych
int sumujTablice(int tablicaInt[], int liczbaElementow)
{
    int akumulator = 0;
    for (int i = 0; i < liczbaElementow; i++)
    {
        akumulator += tablicaInt[i];
    }
    return akumulator;
}
