// BUDGET5 - identyczna z poprzednią wersją, ale tym razem
//           użyto listy z biblioteki standardowej zamiast
//           własnej implementacji

#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <list>
using namespace std;

// Account - klasa abstrakcyjna zawiera obsługę cech wspólnych
//           dla rachunków bieżących i oszczędnościowych. Nie
//           zawiera operacji wypłaty, która różni się między tymi dwoma.
class Account
{
  public:
    Account(unsigned accNo)
    {
      // zainicjalizuj dane
      accountNumber = accNo;
      balance = 0;
      count++;
    }

    // funkcje dostępowe
    int accountNo() { return accountNumber; }
    double acntBalance() { return balance; }
    static int noAccounts() { return count; }

    // funkcje transakcyjne
    void deposit(double amount) { balance += amount; }
    virtual bool withdrawal(double amount)
    {
        if (balance < amount )
        {
             cout << "Brak środków: saldo " << balance
                  << ", wypłata "           << amount
                  << endl;
              return false;
        }
        balance -= amount;
        return true;
    }

    // funkcja wyświetlająca stan rachunku
    void display()
    {
        cout << type()
             << " rachunek " << accountNumber
             << " = "   << balance
             << endl;
    }
    virtual const char* type() { return "Rachunek"; }

  protected:
    static int count;             // liczba rachunków
    unsigned accountNumber;
    double   balance;
};

// alokacja miejsca dla wartości statycznej
int Account::count = 0;

// Checking - własności charakterystyczne dla rachunku bieżącego
class Checking : public Account
{
  public:
    Checking(unsigned accNo) :
      Account(accNo)
    { }

    // przeciąż czystą wirtualną funkcję
    virtual bool withdrawal(double amount);
    virtual const char* type() { return "Rachunek bieżący"; }
};

// withdrawal - przeciąż Account::withdrawal() aby pobierać
//              opłatę za zbyt niskie saldo
bool Checking::withdrawal(double amount)
{
    bool success = Account::withdrawal(amount);

    // gdy saldo spada zbyt nisko, pobierz opłatę
    if (success && balance < 500.00)
    {
        balance -= 0.20;
    }
    return success;
}

// Savings - własności charakterystyczne dla rachunku oszczędnościowego
class Savings : public Account
{
  public:

    Savings(unsigned accNo) : Account(accNo)
    { noWithdrawals = 0; }

    // funkcje transakcyjne
    virtual bool withdrawal(double amount);
    virtual const char* type() { return "Oszczędności"; }

  protected:
    int noWithdrawals;
};

// withdrawal - przeciąż Account::withdrawal() aby pobierać
//              opłatę za zbyt wiele wypłat w miesiącu
bool Savings::withdrawal(double amount)
{
    if (++noWithdrawals > 1)
    {
        balance -= 5.00;
    }
    return Account::withdrawal(amount);
}

// AccountPtr - we contain pointers to Account objects
//              and not to objects themselves
typedef Account* AccountPtr;

// prototypy funkcji
unsigned getAccntNo();
void     process(AccountPtr pAccount);
void     getAccounts(list<AccountPtr>& accList);
void     displayResults(list<AccountPtr>& accList);


// main - pobierz dane i wyświetl podsumowanie
int main(int argcs, char* pArgs[])
{
    // utwórz listę do przechowania kont
    list<AccountPtr> listAccounts;

    // wczytaj rachunki od użytkownika
    getAccounts(listAccounts);

    // wyświetl listę rachunków
    displayResults(listAccounts);

    // Aby pozwolić użytkownikowi zobaczyć wyniki programu
    // poczekaj, aż użytkownik będzie gotowy przed zakończeniem programu.
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();

    return 0;
}

// getAccounts - pobierz dane o kontach
void getAccounts(list<AccountPtr>& accList)
{
    AccountPtr pA;

    // powtarzaj aż do wpisania 'X' lub 'x'
    char   accountType;     // S lub C
    while (true)
    {
        cout << "Wprowadź S dla oszczędności, "
             << "C dla rachunków bieżących, "
             << "X by wyjść:";
        cin >> accountType;
        switch (accountType)
        {
          case 'c':
          case 'C':
            pA = new Checking(getAccntNo());
            break;

          case 's':
          case 'S':
            pA = new Savings(getAccntNo());
            break;

          case 'x':
          case 'X':
            return;

          default:
            cout << "Nie zrozumiałem." << endl;
        }

        // przetwórz utworzony obiekt
        accList.push_back(pA);
        process(pA);
    }
}

// displayResults - wyświetl dane z listy rachunków
void displayResults(list<AccountPtr>& accntList)
{
    // wyświetl podsumowanie
    double total = 0.0;
    cout << "\nPodsumowanie:\n";

    // utwórz iterator i przeiteruj po liście
    // (typem iteratora jest list<AccountPtr>::iterator)
    for (auto iter = accntList.begin();
         iter != accntList.end();
         iter++)
    {
        AccountPtr pAccount = *iter;
        pAccount->display();
        total += pAccount->acntBalance();
    }
    cout << "Saldo łączne = " << total << "\n";
}

// getAccntNo - pobierz numer rachunku dla utworzenia konta
unsigned getAccntNo()
{
    unsigned accntNo;
    cout << "Wprowadź numer rachunku:";
    cin  >> accntNo;
    return accntNo;
}

// process(Account) - wprowadź dane dla rachunków zwykłych
void process(AccountPtr pAccount)
{
    cout << "Wprowadź wartość dodatnią by wpłacić,\n"
         << "ujemną by wypłacić,\n"
         << " lub zero by zakończyć\n";
    double transaction;
    while(true)
    {
        cout << ":";
        cin >> transaction;
        if (transaction == 0)
        {
            break;
        }

        // wpłać
        if (transaction > 0)
        {
            pAccount->deposit(transaction);
        }
        // wypłać
        if (transaction < 0)
        {
            pAccount->withdrawal(-transaction);
        }
    }
}
