// BUDGET4 - Ta wersja używa szablonowej klasy LinkedList
//
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;

#include "LinkedList.h"

// Account - klasa abstrakcyjna zawiera obsługę cech wspólnych
//           dla rachunków bieżących i oszczędnościowych. Nie
//           zawiera operacji wypłaty, która różni się między tymi dwoma.
class Account;
template class LinkedList<Account>;
template class Node<Account>;
class Account
{
  public:
    Account(LinkedList<Account>* pList, unsigned accNo)
    {
      // zainicjalizuj dane
      accountNumber = accNo;
      balance = 0;

      // dodaj się do listy i uaktualnij licznik rachunków
      pNode = new Node<Account>(pList, this);
      pList->addNode(pNode);
      count++;
    }

    // funkcje dostępowe
    int accountNo() { return accountNumber; }
    double acntBalance() { return balance; }
    static int noAccounts() { return count; }

    static Account* first(LinkedList<Account>* pLinkedList)
    {
      Node<Account>* pNode = pLinkedList->firstNode();
      return pNode->current();
    }
    Account* next()
    {
      Node<Account>* pNextNode = pNode->next();
      return pNextNode->current();
    }

    // funkcje transakcyjne
    void deposit(double amount) { balance += amount; }
    virtual bool withdrawal(double amount)
    {
        if (balance < amount )
        {
             cout << "Brak środków: saldo " << balance
                  << ", wypłata "           << amount
                  << endl;
              return false;
        }
        balance -= amount;
        return true;
    }

    // funkcja wyświetlająca stan rachunku
    void display()
    {
        cout << type()
             << " rachunek " << accountNumber
             << " = "   << balance
             << endl;
    }
    virtual const char* type() = 0;

  protected:
    Node<Account>* pNode;

    static int count;             // liczba rachunków
    unsigned accountNumber;
    double   balance;
};

// alokacja miejsca dla wartości statycznej
int Account::count = 0;

// Checking - własności charakterystyczne dla rachunku bieżącego
class Checking : public Account
{
  public:
    Checking(LinkedList<Account>* pLL, unsigned accNo)
      : Account(pLL, accNo) { }

    // przeciąż czystą wirtualną funkcję
    virtual bool withdrawal(double amount);
    virtual const char* type() { return "Rachunek bieżący"; }
};

// withdrawal - przeciąż Account::withdrawal() aby pobierać
//              opłatę za zbyt niskie saldo
bool Checking::withdrawal(double amount)
{
    bool success = Account::withdrawal(amount);

    // gdy saldo spada zbyt nisko, pobierz opłatę
    if (success && balance < 500.00)
    {
        balance -= 0.20;
    }
    return success;
}

// Savings - własności charakterystyczne dla rachunku oszczędnościowego
class Savings : public Account
{
  public:

    Savings(LinkedList<Account>* pLL,
            unsigned accNo) :
      Account(pLL, accNo)
    { noWithdrawals = 0; }

    // transaction functions
    virtual bool withdrawal(double amount);
    virtual const char* type() { return "Oszczędności"; }

  protected:
    int noWithdrawals;
};

// withdrawal - przeciąż Account::withdrawal() aby pobierać
//              opłatę za zbyt wiele wypłat w miesiącu
bool Savings::withdrawal(double amount)
{
    if (++noWithdrawals > 1)
    {
        balance -= 5.00;
    }
    return Account::withdrawal(amount);
}

// prototypy funkcji
unsigned getAccntNo();
void     process(Account* pAccount);
void     getAccounts(LinkedList<Account>* pLinkedList);
void     displayResults(LinkedList<Account>* pLinkedList);


// main - pobierz dane i wyświetl podsumowanie
int main(int argcs, char* pArgs[])
{
    // utwórz listę do przechowania kont
    LinkedList<Account> linkedList;

    // wczytaj rachunki od użytkownika
    getAccounts(&linkedList);

    // wyświetl listę rachunków
    displayResults(&linkedList);

    // Aby pozwolić użytkownikowi zobaczyć wyniki programu
    // poczekaj, aż użytkownik będzie gotowy przed zakończeniem programu.
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();

    return 0;
}

// getAccounts - pobierz dane o kontach
void getAccounts(LinkedList<Account>* pLinkedList)
{
    Account* pA;

    // powtarzaj aż do wpisania 'X' lub 'x'
    char   accountType;     // S lub C
    while (true)
    {
        cout << "Wprowadź S dla oszczędności, "
             << "C dla rachunków bieżących, "
             << "X by wyjść:";
        cin >> accountType;
        switch (accountType)
        {
          case 'c':
          case 'C':
            pA = new Checking(pLinkedList, getAccntNo());
            break;

          case 's':
          case 'S':
            pA = new Savings(pLinkedList, getAccntNo());
            break;

          case 'x':
          case 'X':
            return;

          default:
            cout << "Nie zrozumiałem." << endl;
        }

        // przetwórz utworzony obiekt
        process(pA);
    }
}

// displayResults - wyświetl dane z listy rachunków
void displayResults(LinkedList<Account>* pLinkedList)
{
    // wyświetl podsumowanie
    double total = 0.0;
    cout << "\nPodsumowanie:\n";
    for (Node<Account>* pN = pLinkedList->firstNode();
                        pN != 0;
                        pN = pN->next())
    {
        Account* pA = pN->current();
        pA->display();
        total += pA->acntBalance();
    }
    cout << "Saldo łączne = " << total << "\n";
}

// getAccntNo - pobierz numer rachunku dla utworzenia konta
unsigned getAccntNo()
{
    unsigned accntNo;
    cout << "Wprowadź numer rachunku:";
    cin  >> accntNo;
    return accntNo;
}

// process(Account) - wprowadź dane dla rachunków zwykłych
void process(Account* pAccount)
{
    cout << "Wprowadź wartość dodatnią by wpłacić,\n"
         << "ujemną by wypłacić,\n"
         << " lub zero by zakończyć\n";
    double transaction;
    while(true)
    {
        cout << ":";
        cin >> transaction;
        if (transaction == 0)
        {
            break;
        }

        // wpłać
        if (transaction > 0)
        {
            pAccount->deposit(transaction);
        }
        // wypłać
        if (transaction < 0)
        {
            pAccount->withdrawal(-transaction);
        }
    }
}
