 #include <iostream>

 const int defaultSize = 10;

 // Zdefiniowanie klas wyjątków.
 class XBoundary {};

 class XSize
 {
 public:
     XSize(int newSize):size(newSize) {}
     ~XSize(){}
     virtual int getSize() { return size; }
     virtual void printError()
     { std::cout << "Błąd dotyczący wielkości. Otrzymano: "
         << size << ".\n"; }
 protected:
     int size;
 };

 class XTooBig : public XSize
 {
 public:
     XTooBig(int size):XSize(size) {}
     virtual void printError()
     {
         std::cout << "Zbyt duża! Otrzymano: ";
         std::cout << XSize::size << ".\n";
     }
 };

 class XTooSmall : public XSize
 {
 public:
     XTooSmall(int size):XSize(size) {}
     virtual void printError()
     {
         std::cout << "Zbyt mała! Otrzymano: ";
         std::cout << XSize::size << ".\n";
     }
 };

 class XZero : public XTooSmall
 {
 public:
     XZero(int newSize):XTooSmall(newSize){}
     virtual void printError()
     {
         std::cout << "Otrzymano zero: ";
         std::cout << XSize::size << "\n";
     }
 };

 class XNegative : public XSize
 {
 public:
     XNegative(int size):XSize(size){}
     virtual void printError()
     {
         std::cout << "Wartość ujemna! Otrzymano: ";
         std::cout << XSize::size << "\n";
     }
 };

 class Array
 {
 public:
     // Konstruktory.
     Array(int size = defaultSize);
     Array(const Array &rhs);
     ~Array() { delete [] pType; }

     // Operatory.
     Array& operator=(const Array&);
     int& operator[](int offSet);
     const int& operator[](int offSet) const;

     // Akcesory.
     int getSize() const { return size; }

     // Metoda zaprzyjaźniona.
     friend std::ostream& operator<< (std::ostream&, const Array&);


 private:
     int *pType;
     int  size;
 };

 Array::Array(int newSize):
 size(newSize)
 {
     if (newSize == 0)
         throw XZero(size);

     if (newSize < 0)
         throw XNegative(size);

     if (newSize < 10)
         throw XTooSmall(size);

     if (newSize > 30000)
         throw XTooBig(size);

     pType = new int[newSize];
     for (int i = 0; i < newSize; i++)
         pType[i] = 0;
 }

 int& Array::operator[] (int offset)
 {
     int size = getSize();
     if (offset >= 0 && offset < size)
         return pType[offset];
     throw XBoundary();
     return pType[offset];
 }

 const int& Array::operator[] (int offset) const
 {
     int size = getSize();
     if (offset >= 0 && offset < size)
         return pType[offset];
     throw XBoundary();
     return pType[offset];
 }

 int main()
 {
     try
     {
         int choice;
         std::cout << "Podaj wielkość tablicy: ";
         std::cin >> choice;
         Array intArray(choice);
         for (int j = 0; j < 100; j++)
         {
             intArray[j] = j;
             std::cout << "intArray[" << j << "] OK..."
                 << "\n";
         }
     }
     catch (XBoundary)
     {
         std::cout << "Brak możliwości przetworzenia danych wejściowych.\n";
     }
     catch (XSize& exception)
     {
         exception.printError();
     }
     catch (...)
     {
         std::cout << "Coś poszło źle,"
             << "ale nie wiadomo co!" << "\n";
     }
     std::cout << "Gotowe.\n";
     return 0;
 }
