#include <iostream>
#include <string.h>

typedef unsigned long pDate;

enum SERVICE { PostMaster, Interchange,
    CompuServe, Prodigy, AOL, Internet };

class String
{
public:
    // Konstruktory.
    String();
    String(const char *const);
    String(const String&);
    ~String();

    // Przeciążone operatory.
    char& operator[](int offset);
    char operator[](int offset) const;
    String operator+(const String&);
    void operator+=(const String&);
    String& operator=(const String&);
    friend std::ostream& operator<<
        (std::ostream& stream, String& newString);
    // Ogólne akcesory.
    int getLen() const { return len; }
    const char* getString() const { return string; }
    // static int constructorCount;

private:
    String(int); // Konstruktor prywatny.
    char* string;
    int len;
};

// Konstruktor domyślny tworzy ciąg tekstowy o wielkości 0 bajtów.
String::String()
{
    string = new char[1];
    string[0] = '\0';
    len = 0;
    // std::cout << "\tKonstruktor domyślny ciągu tekstowego.\n";
    // constructorCount++;
}

// Konstruktor prywatny (pomocniczy) używany jedynie
// przez metody klasy w celu utworzenia nowego ciągu tekstowego
// o podanej wielkości. Wypełniony wartościami null.
String::String(int newLen)
{
    string = new char[newLen + 1];
    int i;
    for (i = 0; i <= newLen; i++)
        string[1] = '\0';
    len = newLen;
    // std::cout << "\tKonstruktor String(int).\n";
    // constructorCount++;
}

// Metoda konwertuje tablicę znaków na typ String.
String::String(const char* const cString)
{
    len = strlen(cString);
    string = new char[len + 1];
    int i;
    for (i = 0; i < len; i++)
        string[i] = cString[i];
    string[len]='\0';
    // std::cout << "\tKonstruktor String(char*).\n";
    // constructorCount++;
}

// Konstruktor kopiujący.
String::String(const String &rhs)
{
    len = rhs.getLen();
    string = new char[len + 1];
    int i;
    for (i = 0; i < len; i++)
        string[i] = rhs[i];
    string[len] = '\0';
    // std::cout << "\tKonstruktor String(String&).\n";
    // constructorCount++;
}

// Destruktor zwalnia zarezerwowaną wcześniej pamięć.
String::~String ()
{
    delete [] string;
    len = 0;
    // std::cout << "\tDestruktor String.\n";
}

String& String::operator=(const String &rhs)
{
    if (this == &rhs)
        return *this;
    delete [] string;
    len = rhs.getLen();
    string = new char[len + 1];
    int i;
    for (i = 0; i < len; i++)
        string[i] = rhs[i];
    string[len] = '\0';
    return *this;
    // std::cout << "\toperator=.\n";
}

// Niebędący stałą operator zwraca
// referencję do znaku, aby można było zmienić ten znak.
char &String::operator[](int offset)
{
    if (offset > len)
        return string[len - 1];
    else
        return string[offset];
}

// Będący stałą operator przeznaczony do użycia
// w obiektach stałych (patrz konstruktor kopiujący!)
char String::operator[](int offset) const
{
    if (offset > len)
        return string[len - 1];
    else
        return string[offset];
}

// Tworzy nowy ciąg tekstowy przez dodanie
// bieżącego do rhs.
String String::operator+(const String& rhs)
{
    int  totalLen = len + rhs.getLen();
    String temp(totalLen);
    int i, j;
    for (i = 0; i < len; i++)
        temp[i] = string[i];
    for (j = 0; j < rhs.getLen(); j++, i++)
        temp[i] = rhs[j];
    temp[totalLen]='\0';
    return temp;
}

// Zmienia bieżący ciąg tekstowy, niczego nie zwraca.
void String::operator+=(const String& rhs)
{
    int rhsLen = rhs.getLen();
    int totalLen = len + rhsLen;
    String  temp(totalLen);
    int i, j;
    for (i = 0; i < len; i++)
        temp[i] = string[i];
    for ( j = 0; j < rhs.getLen(); j++, i++)
        temp[i] = rhs[i - len];
    temp[totalLen]='\0';
    *this = temp;
}

// int String::ConstructorCount = 0;

std::ostream& operator<<(std::ostream& stream,
                        String& newString)
{
    stream << newString.getString();
    return stream;
}

class pAddress
{
public:
    pAddress(SERVICE newService,
            const String& newAddress,
            const String& newDisplay):
        service(newService),
        addressString(newAddress),
        displayString(newDisplay)
    {}
    // pAddress(String, String);
    // pAddress();
    // pAddress(const pAddress&);
    ~pAddress(){}
    friend std::ostream& operator<<(
      std::ostream& stream, pAddress& address);
    String& getDisplayString()
    { return displayString; }
private:
    SERVICE service;
    String addressString;
    String displayString;
};

std::ostream& operator<<
  ( std::ostream& stream, pAddress& address)
{
    stream << address.getDisplayString();
    return stream;
}

class PostMasterMessage
{
public:
//  PostMasterMessage();

    PostMasterMessage(const pAddress& newSender,
                      const pAddress& newRecipient,
                      const String& newSubject,
                      const pDate& newCreationDate);

     ~PostMasterMessage(){}

    void Edit(); // Wywołanie edytora dla tej wiadomości.

    pAddress& getSender()  { return sender; }
    pAddress& getRecipient()  { return recipient; }
    String& getSubject()  { return subject; }
    //  void setSender(pAddress& );
    // Inne akcesory składowe.

    // Umieść tutaj metody operatorów, między innymi operatora równości
    // i procedury konwersji zapewniające przekształcenie wiadomości PostMaster
    // na wiadomości w innych formatach.

private:
    pAddress sender;
    pAddress recipient;
    String  subject;
    pDate creationDate;
    pDate lastModDate;
    pDate receiptDate;
    pDate firstReadDate;
    pDate lastReadDate;
};

PostMasterMessage::PostMasterMessage(
    const pAddress& newSender,
    const pAddress& newRecipient,
    const String& newSubject,
    const pDate& newCreationDate):
    sender(newSender),
    recipient(newRecipient),
    subject(newSubject),
    creationDate(newCreationDate),
    lastModDate(newCreationDate),
    firstReadDate(0),
    lastReadDate(0)
{
    std::cout << "Utworzenie wiadomości Postmaster. \n";
}

void PostMasterMessage::Edit()
{
    std::cout << "Wywołanie metody edycji wiadomości Postmaster.\n";
}


int main()
{
    pAddress sender(
        PostMaster, "janek@example.com", "Janek");
    pAddress recipient(
        PostMaster, "krysia@example.com","Krysia");
    PostMasterMessage postMasterMessage(
        sender, recipient, "Pozdrowienia", 0);
    std::cout << "Przegląd wiadomości... \n";
    std::cout << "Od:\t\t"
        << postMasterMessage.getSender() << "\n";
    std::cout << "Do:\t\t"
        << postMasterMessage.getRecipient() << "\n";
    std::cout << "Temat:\t"
        << postMasterMessage.getSubject() << "\n";
    return 0;
}
