#include <iostream>

class Counter
{
public:
    Counter();
    ~Counter(){}
    int getValue() const { return value; }
    void setValue(int x) { value = x; }
    const Counter& operator++();   // Prefiks.
    const Counter operator++(int); // Postfiks.

private:
    int value;
};

Counter::Counter():
value(0)
{}

const Counter& Counter::operator++() // Prefiks.
{
    ++value;
    return *this;
}

const Counter Counter::operator++(int) // Postfiks.
{
    Counter temp(*this);
    ++value;
    return temp;
}

int main()
{
    Counter c;
    std::cout << "Wartość c wynosi " << c.getValue()
        << "\n";
    c++;
    std::cout << "Wartość c wynosi " << c.getValue()
        << "\n";
    ++c;
    std::cout << "Wartość c wynosi " << c.getValue()
        << "\n";
    Counter a = ++c;
    std::cout << "Wartość a wynosi " << a.getValue();
    std::cout << ", natomiast wartość c wynosi " << c.getValue() << "\n";
    a = c++;
    std::cout << "Wartość a wynosi " << a.getValue();
    std::cout << ", natomiast wartość c wynosi " << c.getValue() << "\n";
    return 0;
}
