#include <iostream>

class SimpleCat
{
public:
    SimpleCat();
    SimpleCat(SimpleCat&);
    ~SimpleCat();

    int getAge() const { return itsAge; }
    void setAge(int age) { itsAge = age; }

private:
    int itsAge;
};

SimpleCat::SimpleCat()
{
    std::cout << "Konstruktor klasy SimpleCat...\n";
    itsAge = 10;
}

SimpleCat::SimpleCat(SimpleCat&)
{
    std::cout << "Konstruktor kopiujący klasy SimpleCat...\n";
}

SimpleCat::~SimpleCat()
{
    std::cout << "Destruktor klasy SimpleCat...\n";
}

const SimpleCat * const
FunctionTwo (const SimpleCat *const theCat);

int main()
{
    std::cout << "Utworzenie obiektu...\n";
    SimpleCat Frisky;
    std::cout << "Frisky ma ";
    std::cout << Frisky.getAge() << " lat.\n";
    int age = 5;
    Frisky.setAge(age);
    std::cout << "Frisky ma ";
    std::cout << Frisky.getAge() << " lat.\n";
    std::cout << "Wywołanie FunctionTwo...\n";
    FunctionTwo(&Frisky);
    std::cout << "Frisky ma ";
    std::cout << Frisky.getAge() << " lat.\n";
    return 0;
}

// FunctionTwo, przekazanie wskaźnika const.
const SimpleCat * const
FunctionTwo (const SimpleCat * const theCat)
{
    std::cout << "Zakończenie działania FunctionTwo...\n";
    std::cout << "Frisky ma teraz " << theCat->getAge();
    std::cout << " lat. \n";
    // theCat->setAge(8); const!
    return theCat;
 }
