#include <iostream>

class Dog
{
public:
    void speak()const { std::cout << "Hau!\n"; }
    void move() const { std::cout << "Chodzenie przy nodze...\n"; }
    void eat() const { std::cout << "Pochłanianie jedzenia...\n"; }
    void growl() const { std::cout << "Grrrrr\n"; }
    void whimper() const { std::cout << "Skowyt...\n"; }
    void rollOver() const { std::cout << "Turlanie się...\n"; }
    void playDead() const
        { std::cout << "Czy to już koniec małego cezara?\n"; }
};

typedef void (Dog::*PDF)()const;

int main()
{
    const int MaxFuncs = 7;
    PDF dogFunctions[MaxFuncs] =
        {   &Dog::speak,
            &Dog::move,
            &Dog::eat,
            &Dog::growl,
            &Dog::whimper,
            &Dog::rollOver,
            &Dog::playDead
        };

    Dog* pDog =0;
    int method;
    bool fQuit = false;

    while (!fQuit)
    {
        std::cout << "(0) Wyjście (1) Głos (2) Ruch (3) Jedzenie (4) Warknięcie";
        std::cout << " (5) Skowyt (6) Turlanie się (7) Udawanie martwego: ";
        std::cin >> method;
        if (method == 0)
        {
            fQuit = true;
            break;
        }
        else
        {
            pDog = new Dog;
            (pDog->*dogFunctions[method - 1])();
            delete pDog;
        }
    }
    return 0;
}
