#include <iostream>

class Mammal
{
public:
    Mammal():age(1) { std::cout << "Konstruktor klasy Mammal...\n"; }
    virtual ~Mammal() { std::cout << "Destruktor klasy Mammal...\n"; }
    virtual void speak() const { std::cout << "Ssak wydaje dźwięki!\n"; }
protected:
    int age;
};

class Cat: public Mammal
{
public:
    Cat() { std::cout << "Konstruktor klasy Cat...\n"; }
    ~Cat() { std::cout << "Destruktor klasy Cat...\n"; }
    void speak() const { std::cout << "Miau!\n"; }
    void purr() const { std::cout << "Rrrrrrrrrrr!\n"; }
};

class Dog: public Mammal
{
public:
    Dog() { std::cout << "Konstruktor klasy Dog...\n"; }
    ~Dog() { std::cout << "Destruktor klasy Dog...\n"; }
    void speak() const { std::cout << "Hau!\n"; }
};

int main()
{
    const int numberMammals = 3;
    Mammal* zoo[numberMammals];
    Mammal* pMammal;
    int choice, i;
    for (i = 0; i < numberMammals; i++)
    {
        std::cout << "(1)Dog (2)Cat: ";
        std::cin >> choice;
        if (choice == 1)
            pMammal = new Dog;
        else
            pMammal = new Cat;

        zoo[i] = pMammal;
    }

    std::cout << "\n";

    for (i = 0; i < numberMammals; i++)
    {
        zoo[i]->speak();

        Cat *pRealCat =  dynamic_cast<Cat *> (zoo[i]);

        if (pRealCat)
            pRealCat->purr();
        else
            std::cout << "O nie, to nie jest kot!\n";

        delete zoo[i];
        std::cout << "\n";
    }

    return 0;
}
