#include <iostream>

class Tricycle
{
public:
    Tricycle();                     // Konstruktor domyślny.
    Tricycle(const Tricycle&);      // Konstruktor kopiujący.
    ~Tricycle();                    // Destruktor.
    int getSpeed() const { return *speed; }
    void setSpeed(int newSpeed) { *speed = newSpeed; }
    void pedal();
    void brake();

private:
    int *speed;
};

Tricycle::Tricycle()
{
    speed = new int;
    *speed = 5;
}

Tricycle::Tricycle(const Tricycle& rhs)
{
    speed = new int;
    *speed = rhs.getSpeed();
}

Tricycle::~Tricycle()
{
    delete speed;
    speed = NULL;
}

void Tricycle::pedal()
{
    setSpeed(*speed + 1);
    std::cout << "\nJazda rowerem trójkołowym, szybkość wynosi " << getSpeed() << " km/h.\n";
}
void Tricycle::brake()
{
    setSpeed(*speed - 1);
    std::cout << "\nJazda rowerem trójkołowym, szybkość wynosi " << getSpeed() << " km/h.\n";
}

int main()
{
    std::cout << "Utworzenie reweru trójkołowego o nazwie wichita...";
    Tricycle wichita;
    wichita.pedal();
    std::cout << "Utworzenie reweru trójkołowego o nazwie dallas...\n";
    Tricycle dallas(wichita);
    std::cout << "Szybkość roweru wichita wynosi: " << wichita.getSpeed() << "\n";
    std::cout << "Szybkość roweru dallas wynosi: " << dallas.getSpeed() << "\n";
    std::cout << "Ustawienie rowerowi wichita szybkości 10...\n";
    wichita.setSpeed(10);
    std::cout << "Szybkość roweru wichita wynosi: " << wichita.getSpeed() << "\n";
    std::cout << "Szybkość roweru dallas wynosi: " << dallas.getSpeed() << "\n";
    return 0;
}
