#include <iostream>

enum BREED { YORKIE, CAIRN, DANDIE, SHETLAND, DOBERMAN, LAB };

class Mammal
{
public:
    // Konstruktory.
    Mammal();
    ~Mammal();

    // Akcesory.
    int getAge() const { return age; }
    void setAge(int newAge) { age = newAge; }
    int getWeight() const { return weight; }
    void setWeight(int newWeight) { weight = newWeight; }

    // Pozostałe metody składowe.
    void speak() const { std::cout << "Dźwięk ssaka!\n"; }
    void sleep() const { std::cout << "Ciiiicho. Właśnie śpię.\n"; }

protected:
    int age;
    int weight;
};

class Dog : public Mammal
{
public:
    // Konstruktory.
    Dog();
    ~Dog();

    // Akcesory.
    BREED getBreed() const { return breed; }
    void setBreed(BREED newBreed) { breed = newBreed; }

    // Pozostałe metody składowe.
    void wagTail() { std::cout << "Macham ogonem...\n"; }
    void begForFood() { std::cout << "Proszę o jedzenie...\n"; }

private:
    BREED breed;
};

Mammal::Mammal():
age(2),
weight(5)
{
    std::cout << "Konstruktor klasy Mammal...\n";
}

Mammal::~Mammal()
{
    std::cout << "Destruktor klasy Mammal...\n";
}

Dog::Dog():
breed(YORKIE)
{
    std::cout << "Konstruktor klasy Dog...\n";
}

Dog::~Dog()
{
    std::cout << "Destruktor klasy Dog...\n";
}

int main()
{
    Dog fido; // Utworzenie egzemplarza klasy Dog.
    fido.speak();
    fido.wagTail();
    std::cout << "Fido ma " << fido.getAge() << " lata.\n";
    return 0;
}
