#include <iostream>
#include <limits>

int main()
{
    char letterF { 'F' };       // \x46    (ASCII)
    char8_t letterV { u8'V' };  // \x56    (UTF-8)
    char16_t chinese { u'鼠' }; // \x9f20  (UTF-16)
    char32_t emoji { U'🧙' };  // \x1f9d9 (UTF-32)
  
    wchar_t omega { L'☠️' };   // \x2620  (wide character)
  
    /* Przechowuje wartość
       0x40 szesnastkowo,
       64 dziesiętnie, a jako znak to @
       (zobacz: Tabela ASCII) */
    signed char sc { '\x40' };
  
    /* Wartość 255 dziesiętnie */
    unsigned char un { 0xFF };
  
    constexpr int scMax
    {
        std::numeric_limits<signed char>::max()
    };
  
    constexpr int ucMax
    {
        std::numeric_limits<unsigned char>::max()
    };
  
    std::cout << "signed char o wartości 64 to " << sc;
    std::cout << std::endl;
    std::cout << "signed char's max = " << scMax;
    std::cout << std::endl;
    std::cout << "unsigned char's max = " << ucMax;
    std::cout << std::endl;
    
    return EXIT_SUCCESS;
}
