#include <iostream>
#include <memory>

int main()
{
    setlocale(LC_ALL, "");
  
    /* Stworzenie wskaźnika inteligentnego „shared_ptr” */
    std::shared_ptr<int> ptr = std::make_shared<int>(64);
  
    /* Nadanie nowej wartości wskazywanej zmiennej. */
    *ptr = 128;
    
    std::cout << "*ptr = " << *ptr << std::endl;
  
    /* Skopiowanie wskaźnika „shared_ptr” */
    auto ptr_2 = ptr;
  
    std::cout << "ptr = " << ptr << std::endl;
    std::cout << "ptr_2 = " << ptr_2 << std::endl;
    std::cout << "Licznik odwołań: " << ptr_2.use_count() << std::endl;
  
    /* Wskaźnik „shared_ptr” zostanie automatycznie usunięty,
       ale możliwe jest też usunięcie poprzez reset(); */
  
    ptr_2.reset();
  
    std::cout << "ptr_2 = " << ptr_2 << std::endl;
    std::cout << "Licznik odwołań: " << ptr_2.use_count() << std::endl;
  
    return EXIT_SUCCESS;
}
