#include <iostream>
#include <memory>

int main()
{
    /* Niskopoziomowe stworzenie wskaźnika za pomocą „new” */
    int* lowptr = new int(32);
  
    std::cout << "*lowptr = " << *lowptr << std::endl;
  
    delete lowptr; /* Wymagane manualne usunięcie */
  
    /* --------------------------------------------------- */
  
    /* Stworzenie wskaźnika inteligentnego „unique_ptr” */
    std::unique_ptr<int> ptr = std::make_unique<int>(64);
  
    /* Nadanie nowej wartości wskazywanej zmiennej. */
    *ptr = 128;
  
    std::cout << "*ptr = " << *ptr << std::endl;
  
    /* Możliwe jest przypisanie obiektu do innego wskaźnika
       za pomocą std::move();. Uwaga: Nie jest to skopiowanie,
       tylko przeniesienie. */
    auto ptr_2 = std::move(ptr);
    std::cout << "ptr_2 = " << ptr_2 << std::endl;
    std::cout << "ptr = " << ptr << std::endl;
    
    /* Wskaźnik „unique_ptr” zostanie automatycznie usunięty,
       ale możliwe jest też usunięcie poprzez reset(); */
    ptr_2.reset();
  
    std::cout << "ptr_2 = " << ptr_2 << std::endl;
    
    return EXIT_SUCCESS;
}
