#include <iostream>

template <typename T>
concept Multiplicative = requires(T a, T b) { a * b; };

template <typename T>
concept Unsigned = std::is_unsigned<T>::value;

template <typename T>
requires Unsigned<T> && Multiplicative<T>
T mul(T a, T b) { return a * b; }

int main()
{
    ::setlocale(LC_ALL, "");
  
    mul("bad", "arguments"); //error
  
    mul(2, 2); //error
  
    std::cout << "2 * 2 = " << mul(2u, 2u) //OK
      << std::endl;
  
    return EXIT_SUCCESS;
}
