#include <iostream>

int main()
{
    int var1[] { 1, 2, 3 };
  
    /* Wskaźnik do tablicy „var1” */
    int* pointer = &var1;
  
    /* Zwiększenie wskaźnika spowoduje przejście
       do kolejnego elementu w tablicy „var1” */
    pointer++;
    std::cout << *pointer << std::endl;
  
    /* Tutaj zwiększana jest wskazywana wartość */
    (*pointer)++;
    std::cout << *pointer << std::endl;
  
    /* Uwaga: W arytmetyce wskaźników łatwo wyjść
       poza zakres i odczytać nie to miejsce w pamięci,
       które się planowało. */
    pointer += 5;
    std::cout << *pointer << std::endl;
  
    int var2 { 8 };
    
    /* Referencja do pojedynczej wartości typu „int”.
       (Do tablicy wyglądałoby to int(&reference)[] = var1;) */
    int& reference = var2;
  
    /* Zwiększenie referencji powoduje zwiększenie
       wartości zmiennej do której się ona odwołuje. */
    reference++;
    std::cout << reference << std::endl;
    
    return EXIT_SUCCESS;
}
