/*
  Based on Working Draft, Standard for Programming Language C++ (Doc: N4830)
  open-std.org, 2019
*/

#include <iostream>
#include <coroutine>

struct generator
{
    struct promise_type
    {
        int current_value;
        auto yield_value(int value)
        {
            current_value = value;
            return std::suspend_always{};
        }
      
        static auto get_return_object_on_allocation_failure()
        {
            return generator { nullptr };
        }
      
        auto get_return_object()
        {
            return generator { handle::from_promise(*this));
        }
        
        auto initial_suspend() { return std::suspend_always{}; }
        auto final_suspend() { return std::suspend_always{}; }
        void unhandled_exception() { std::terminate(); }
        void return_void() { }
    };
      
    using handle = std::coroutine_handle<promise_type>;
      
    bool move_next()
    {
        hCoroutine.resume(); return not hCoroutine.done();
    }
      
    int current_value()
    {
        return hCoroutine.promise().current_value;
    }
    
    handle hCoroutine;
};
  
generator func1()
{
    for (int i = 1; i < 10 + 1; i++)
    {
        co_yield i;
    }
}
  
int main()
{
    auto gen = func1();
  
    while (gen.move_next())
        std::cout << gen.current_value() << " ";
  
    return EXIT_SUCCESS;
}
