#include <iostream>
#include <fstream>

using namespace std;

class redirect_cout_region {
    using buftype = decltype(cout.rdbuf());

    ofstream ofs;
    buftype buf_backup;

public:
    explicit redirect_cout_region(const string &filename)
        : ofs{filename}, buf_backup{cout.rdbuf(ofs.rdbuf())}
    {}

    redirect_cout_region()
        : ofs{}, buf_backup{cout.rdbuf(ofs.rdbuf())}
    {}

    ~redirect_cout_region() { cout.rdbuf(buf_backup); }
};

void my_output_heavy_function()
{
    cout << "Pewne dane wyjściowe\n";
    cout << "Ta funkcja naprawdę wykonuje wiele zadań\n";
    cout << "...Jeszcze więcej danych z funkcji...\n";
    // ...
}

int main()
{
    cout << "Dane skierowane do standardowego wyjścia.\n";

    {
        redirect_cout_region _ {"output.txt"};
        cout << "Dane zostały umieszczone w pliku output.txt.\n";
        my_output_heavy_function();
        redirect_cout_region _2 {"fofo.txt"};
        cout << "fofo\n";
    }

    {
        redirect_cout_region _;
        cout << "Te dane wyjściowe zostaną całkowicie odrzucone.\n";
    }

    cout << "Ponownie dane skierowane do standardowego wyjścia.\n";
}
