#include <iostream>
#include <string_view>

using namespace std;

void print(string_view v)
{
    // Uwaga: nie należy oczekiwać ciągu tekstowego zakończonego znakiem null.
    const auto words_begin (v.find_first_not_of(" \t\n"));
    v.remove_prefix(min(words_begin, v.size()));

    const auto words_end   (v.find_last_not_of(" \t\n"));

    if (words_end != string_view::npos) {
        v.remove_suffix(v.size() - words_end - 1);
    }

    cout << "wielkość: " << v.length()
         << " [" << v << "]\n";
}

int main(int argc, char *argv[])
{
    print(argv[0]);
    print({});
    print("tablica const char *");
    print("literał std::string_view"sv);
    print("egzemplarz std::string"s);

    print("   \t\n foobar  \n  \t ");

    char cstr[] {'a', 'b', 'c'}; // Brak znaku null na końcu.
    print(string_view(cstr, sizeof(cstr)));
}

