#include <iostream>
#include <thread>
#include <mutex>

using namespace std;
using namespace chrono_literals;

mutex mut_a;
mutex mut_b;

static void deadlock_func_1()
{
    cout << "Niepoprawne nałożenie blokady na muteks A przez funkcję f1..." << endl;
    lock_guard<mutex> la {mut_a};

    this_thread::sleep_for(100ms);

    cout << "Niepoprawne nałożenie blokady na muteks B przez funkcję f1..." << endl;
    lock_guard<mutex> lb {mut_b};

    cout << "Niepoprawne nałożenie blokady na oba muteksy przez funkcję f1." << endl;
}

static void deadlock_func_2()
{
    cout << "Niepoprawne nałożenie blokady na muteks B przez funkcję f2..." << endl;
    lock_guard<mutex> lb {mut_b};

    this_thread::sleep_for(100ms);

    cout << "Niepoprawne nałożenie blokady na muteks A przez funkcję f2..." << endl;
    lock_guard<mutex> la {mut_a};

    cout << "Niepoprawne nałożenie blokady na oba muteksy przez funkcję f2." << endl;
}

static void sane_func_1()
{
    scoped_lock l {mut_a, mut_b};

    cout << "Poprawne nałożenie blokady na oba muteksy przez funkcję f1." << endl;
}

static void sane_func_2()
{
    scoped_lock l {mut_b, mut_a};

    cout << "Poprawne nałożenie blokady na oba muteksy przez funkcję f2." << endl;
}

int main()
{
    {
        thread t1 {sane_func_1};
        thread t2 {sane_func_2};

        t1.join();
        t2.join();
    }

    {
        thread t1 {deadlock_func_1};
        thread t2 {deadlock_func_2};

        t1.join();
        t2.join();
    }
}
