#include <iostream>
#include <chrono>
#include <ratio>
#include <cmath>
#include <iomanip>
#include <optional>

using namespace std;

using seconds      = chrono::duration<double>;
using milliseconds = chrono::duration<double, ratio_multiply<seconds::period, milli>>;
using microseconds = chrono::duration<double, ratio_multiply<seconds::period, micro>>;

static pair<string, seconds> get_input()
{
    string s;

    const auto tic (chrono::steady_clock::now());
    if (!(cin >> s)) {
        return {{}, {}};
    }
    const auto toc (chrono::steady_clock::now());

    return {s, toc - tic};
}

int main()
{
    while (true) {
        cout << "Proszę jak najszybciej wpisać \"C++17\".\n> ";

        const auto [user_input, diff] = get_input();

        if (user_input == "") { break; }

        if (user_input == "C++17") {
            cout << "Brawo. Twój wynik:\n" << fixed << setprecision(2)
                  << setw(12) <<               diff.count() << " sekund.\n"
                  << setw(12) << milliseconds(diff).count() << " milisekund.\n"
                  << setw(12) << microseconds(diff).count() << " mikrosekund.\n";
            break;
        } else {
            cout << "Nieprawidłowe dane wejściowe. Spróbuj ponownie.\n";
        }
    }
}
