#include <iostream>
#include <tuple>
#include <map>
#include <stdexcept>

bool divide_remainder(int dividend, int divisor, int &fraction, int &remainder)
{
    if (divisor == 0) {
        return false;
    }
    fraction  = dividend / divisor;
    remainder = dividend % divisor;
    return true;
}

std::pair<int, int> divide_remainder(int dividend, int divisor)
{
    if (divisor == 0) {
        throw std::runtime_error{"Próba dzielenia przez 0."};
    }
    return {dividend / divisor, dividend % divisor};
}

int main()
{
    { // Stary sposób.
        int fraction, remainder;
        const bool success {divide_remainder(16, 3, fraction, remainder)};
        if (success) {
            std::cout << "16 / 3 to " << fraction << " plus reszta z dzielenia " << remainder << "\n";
        }
    }

    { // Sposób w C++11.
        const auto result (divide_remainder(16, 3));
        std::cout << "16 / 3 to " << result.first << " plus reszta z dzielenia " << result.second << "\n";
    }

    { // C++11, ignorując część ułamkową wyniku.
        int remainder;
        std::tie(std::ignore, remainder) = divide_remainder(16, 5);
        std::cout << "16 % 5 to " << remainder << "\n";
    }

    { // C++17, użycie strukturalnych wiązań.
        auto [fraction, remainder] = divide_remainder(16, 3);
        std::cout << "16 / 3 to " << fraction << " plus reszta z dzielenia " << remainder << "\n";
    }

    { // C++17, umieszczenie elementów krotki w poszczególnych zmiennych.
        std::tuple<int, float, long> tup {1, 2.0, 3};
        auto [a, b, c] = tup;
        std::cout << a << ", " << b << ", " << c << "\n";
    }

    { // C++17, użycie strukturalnych wiązań w pętli for.

        std::map<std::string, size_t> animal_population {
            {"ludzi",   7000000000},
            {"kurczaków", 17863376000},
            {"wielbłądów",   24246291},
            {"owiec",    1086881528}
            /* … */
        };

        for (const auto &[species, count] : animal_population) {
                std::cout << "Mamy " << count << " " << species << " żyjących na naszej planecie.\n";
        }
    }
}
