#include <iostream>
#include <shared_mutex>
#include <thread>
#include <vector>

using namespace std;
using namespace chrono_literals;

shared_mutex shared_mut;

using shrd_lck = shared_lock<shared_mutex>;
using uniq_lck = unique_lock<shared_mutex>;

void print_exclusive()
{
    uniq_lck l {shared_mut, defer_lock};

    if (l.try_lock()) {
        cout << "Nałożno blokadę w trybie wyłączności.\n";
    } else {
        cout << "Nie udało się nałożyć blokady w trybie wyłączności.\n";
    }
}

void exclusive_throw()
{
    uniq_lck l {shared_mut};
    throw 123;

}

int main()
{

    {
        shrd_lck sl1 {shared_mut};

        cout << "Pierwsza blokada w trybie współdzielonym.\n";

        {
            shrd_lck sl2 {shared_mut};

            cout << "Druga blokada w trybie współdzielonym.\n";

            print_exclusive();
        }

        cout << "Ponownie pierwsza blokada w trybie współdzielonym.\n";

        print_exclusive();

    }
    cout << "Blokada została zwolniona.\n";

    try {
        exclusive_throw();
    } catch (int e) {
        cout << "Nastąpiło zgłoszenie wyjątku " << e << '\n';
    }

    print_exclusive();
}
