#include <iostream>
#include <cstdio>
#include <map>
#include <string>

template <typename T>
void print_charcount_cpp11(const T &map, char c)
{
    const auto itr (map.find(c));
    if (itr != map.end()) {
        // Iterator *itr jest poprawny i zostanie wykorzystany do pewnych operacji.
        std::cout << "Mamy " << itr->second << " " << c << " znaków." << "\n";
    } else {
        // Iterator *itr jest niepoprawny, nie wolno uzyskać do niego dostępu, choć jest dostępny.
        std::cout << "Mamy " << 0 << " " << c << " znaków." << "\n";
    }
    // Iterator *itr niekoniecznie pozwala na bezpieczną dereferencję, ale wciąż pozostaje dostępny.
}

template <typename T>
void print_charcount_cpp17(const T &map, char c)
{
    if (const auto itr (map.find(c)); itr != map.end()) {
        std::cout << "Mamy " << itr->second << " " << c << " znaków." << "\n";
    } else {
        std::cout << "Mamy " << 0 << " " << c << " znaków." << "\n";
    }
    // Iterator *itr jest tutaj niedostępny.
}

int main()
{
    {
        std::map<char, size_t> character_map {{'a', 10}, {'b', 20} /* , ... */};
        print_charcount_cpp11(character_map, 'a');
        print_charcount_cpp11(character_map, 'c');

        print_charcount_cpp17(character_map, 'a');
        print_charcount_cpp17(character_map, 'c');
    }

    {
        std::cout << "Podaj znak: ";
        switch (char c (getchar()); c) {
        case 'a' ... 'z':
            std::cout << "Wpisałeś małą literę: " << c << "\n";
            break;
        case 'A' ... 'Z':
            std::cout << "Wpisałeś dużą literę: " << c << "\n";
            break;
        default:
            std::cout << "Wpisałeś coś innego: " << c << "\n";
        }
    }
}


