/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <list>
#include <algorithm>
#include <iostream>
#include "print.hpp"
using namespace std;

// obiekt funkcyjny dodający wartość, ktorą został zainicjalizowany
class AddValue {
  private:
    int theValue;    // wartość do dodania
  public:
    // konstruktor inicjalizuje wartość do dodania
    AddValue(int v) : theValue(v) {
    }

    // 'wywołanie funkcji' wobec elementu dodaje wartość
    void operator() (int& elem) const {
        elem += theValue;
    }
};

int main()
{
    list<int> coll;

    // wstaw elementy od 1 do 9
    for (int i=1; i<=9; ++i) {
        coll.push_back(i);
    }

    PRINT_ELEMENTS(coll,"wartości początkowe:            ");

    // do każdego elementu dodaj wartość 10
    for_each (coll.begin(), coll.end(),    // zakres
              AddValue(10));               // operacja

    PRINT_ELEMENTS(coll,"po dodaniu liczby 10:           ");

    // do każdego elementu dodaj wartość pierwszego elementu
    for_each (coll.begin(), coll.end(),    // zakres
              AddValue(*coll.begin()));    // operacja

    PRINT_ELEMENTS(coll,"po dodaniu pierwszego elementu: ");
}

