/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <random>
#include <iostream>
#include <sstream>

void printNumbers (std::default_random_engine& dre)
{
    for (int i=0; i<6; ++i) {
        std::cout << dre() << " ";
    }
    std::cout << std::endl;
}

int main()
{
    // utwórz mechanizm i wygeneruj liczby
    std::default_random_engine dre;
    printNumbers(dre);

    // utwórz identyczny mechanizm i wygeneruj liczby
    std::default_random_engine dre2; // ten sam stan początkowy co dre
    printNumbers(dre2);

    // utwórz mechanizm ze stanem początkowym zadanym zarodkiem
    std::default_random_engine dre3(42);
    printNumbers(dre3);

    // zapisz stan mechanizmu dre
    std::stringstream engineState;
    engineState << dre;

    // generuj liczby zgodnie z bieżącym stanem dre
    printNumbers(dre);

    // przywróć zapisany stan dre i ponownie generuj liczby
    engineState >> dre;
    printNumbers(dre);

    // przywróć zapisany stan dre, pomiń dwie liczby i ponownie generuj liczby
    engineState.clear();  // wyczyść bit EOF
    engineState.seekg(0); // i przesuń pozycję odczytu do pozycji początkowej
    engineState >> dre;
    dre.discard(2);
    printNumbers(dre);
}
