/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <bitset>
#include <iostream>
#include <string>
#include <limits>
using namespace std;

int main()
{
    // wyświetla reprzentację bitowś kilku liczb
    cout << "267 w postaci binarnej liczby typu short:  "
         << bitset<numeric_limits<unsigned short>::digits>(267)
         << endl;

    cout << "267 w postaci binarnej liczby typu long:   "
         << bitset<numeric_limits<unsigned long>::digits>(267)
         << endl;

    cout << "10000000 binarnie na 24-bitach:        "
         << bitset<24>(1e7) << endl;

    // wypisz binarną reprezentację do łańcucha znakowego
    string s = bitset<42>(12345678).to_string();
    cout << "12345678 binarnie na 24 bitach:        " << s << endl;

    // przeksztalć reprezentację binarną do postaci liczby całkowitej
    cout << "\"1000101011\" w postaci liczbowej:          "
         << bitset<100>(string("1000101011")).to_ullong() << endl;
}

