/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <forward_list>
#include <iostream>
#include <algorithm>
#include <iterator>
#include <string>
using namespace std;

void printLists (const string& s, const forward_list<int>& l1,
                                  const forward_list<int>& l2)
{
    cout << s << endl;
    cout << " lista1: ";
    copy (l1.cbegin(), l1.cend(), ostream_iterator<int>(cout," "));
    cout << endl << " lista2: ";
    copy (l2.cbegin(), l2.cend(), ostream_iterator<int>(cout," "));
    cout << endl;
}

int main()
{
    // utwórz dwie listy jednokierunkowe
    forward_list<int> list1 = { 1, 2, 3, 4 };
    forward_list<int> list2 = { 77, 88, 99 };
    printLists ("inicjalizacja:", list1, list2);

    // wstaw sześć nowych elementów na początku list2
    list2.insert_after(list2.before_begin(),99);
    list2.push_front(10);
    list2.insert_after(list2.before_begin(), {10,11,12,13} );
    printLists ("6 nowych elementów:", list1, list2);

    // wstaw wszystkie elementy list2 na początku list1
    list1.insert_after(list1.before_begin(),
                       list2.begin(),list2.end());
    printLists ("list2 do list1:", list1, list2);

    // usuń drugi element i elementy po elemencie o wartości 99
    list2.erase_after(list2.begin());
    list2.erase_after(find(list2.begin(),list2.end(),
                           99),
                      list2.end());
    printLists ("usuń drugi i elementy po 99:", list1, list2);

    // posortuj list1, przypisz ją do list2 i usuń duplikaty
    list1.sort();
    list2 = list1;
    list2.unique();
    printLists ("posortowana i unikatowe elementy:", list1, list2);

    // złącz obie posortowane listy w list1
    list1.merge(list2);
    printLists ("połączone:", list1, list2);
}

