/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <string>
#include <iostream>
#include <limits>
#include <exception>

int main()
{
    try {
        // konwersja na typ liczbowy
        std::cout << std::stoi (" 77") << std::endl;
        std::cout << std::stod (" 77.7") << std::endl;
        std::cout << std::stoi ("-0x77") << std::endl;

        // sprawdzenie indeksu pierwszego nieprzetworzonego znaku
        std::size_t idx;
        std::cout << std::stoi (" 44 imię jego", &idx) << std::endl;
        std::cout << " indeks pierwszego nieprzetworzonego znaku: "
                  << idx << std::endl;

        // przy podstawie 16 i 8
        std::cout << std::stoi (" 42", nullptr, 16) << std::endl;
        std::cout << std::stol ("789", &idx, 8) << std::endl;
        std::cout << " indeks pierwszego nieprzetworzonego znaku: " << idx << std::endl;

        // konwersja wartości liczbowej na string
        long long ll = std::numeric_limits<long long>::max();
        std::string s = std::to_string(ll); // konwertuje maksymalną wartość
                                            //typu long long na typ string
        std::cout << s << std::endl;

        // próba konwersji odwrotnej
        std::cout << std::stoi(s) << std::endl; // zgłasza wyjątek out_of_range
    }
    catch (const std::exception& e) {
        std::cout << e.what() << std::endl;
    }
}
