/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <algorithm>
#include <iterator>
#include <list>
#include <iostream>
using namespace std;

int main()
{
    list<int> coll;

    // wstaw elementy od 6 do 1 oraz od 1 do 6
    for (int i=1; i<=6; ++i) {
        coll.push_front(i);
        coll.push_back(i);
    }

    // wypisz wszystkie elementy kolekcji
    cout << "przed:  ";
    copy (coll.cbegin(), coll.cend(),         // źródło
          ostream_iterator<int>(cout," "));   // przeznaczenie
    cout << endl;

    // usuń wszystkie elementy o wartości 3
    remove (coll.begin(), coll.end(),         // zakres
            3);                               // wartość

    // wypisz wszystkie elementy kolekcji
    cout << "po: ";
    copy (coll.begin(), coll.end(),           // zrodlo
          ostream_iterator<int>(cout," "));   // przeznaczenie
    cout << endl;
}
