/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <algorithm>
#include <deque>
#include <iostream>
using namespace std;

int main()
{
    deque<int> coll = { 1, 3, 19, 5, 13, 7, 11, 2, 17 };

    int x = 5;
    int y = 12;
    auto pos = find_if (coll.cbegin(), coll.cend(),  // zakres przeszukiwany
                        [=](int i) {                 // kryterium wyszukiwania
                             return i > x && i < y;
                        });
    cout << "pierwszy element >5 i <12: " << *pos << endl;
}
