/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <algorithm>
#include <iterator>
#include <list>
#include <vector>
#include <deque>
#include <set>
#include <iostream>
using namespace std;

int main()
{
    list<int> coll1  = { 1,2, 3, 4, 5, 6, 7, 8, 9 };

    // przekopiuj elementy z kolekcji coll1 do coll2 dolączając je
    vector<int> coll2;
    copy (coll1.cbegin(), coll1.cend(),    // źródło
          back_inserter(coll2));           // przeznaczenie

    // przekopiuj elementy z kolekcji coll1 do coll3 wstawiając je na początek
    // - odwraca kolejność elementow
    deque<int> coll3;
    copy (coll1.cbegin(), coll1.cend(),    // źródło
          front_inserter(coll3));          // przeznaczenie

    // przekopiuj elementy z kolekcji coll1 do coll4
    // - jedyny wstawiacz dzialający w przypadku kolekcji asocjacyjnych
    set<int> coll4;
    copy (coll1.cbegin(), coll1.cend(),    // źródło
          inserter(coll4,coll4.begin()));  // przeznaczenie
}
