/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <vector>
#include <algorithm>
#include <iterator>
#include "print.hpp"
using namespace std;

int main()
{
    vector<int> coll;

    // utworz wstawiacz końcowy dla kontenera coll
    // - niewygodny sposob
    back_insert_iterator<vector<int> > iter(coll);

    // wstaw elementy z wykorzystaniem typowego interfejsu iteratora
    *iter = 1;
    iter++;
    *iter = 2;
    iter++;
    *iter = 3;
    PRINT_ELEMENTS(coll);

    // utwórz wstawiacz końcowy i wstaw elementy
    // - wygodny sposob
    back_inserter(coll) = 44;
    back_inserter(coll) = 55;
    PRINT_ELEMENTS(coll);

    // użyj wstawiacza końcowego do ponownego wstawienia wszystkich elementów
    // - zarezerwuj wystarczająca ilość pamięci, aby uniknąć realokacji
    coll.reserve(2*coll.size());
    copy (coll.begin(), coll.end(),    // źródło
          back_inserter(coll));        // przeznaczenie
    PRINT_ELEMENTS(coll);
}
