/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
// pliki naglowkowe dla operacji wejscia-wyjscia na plikach
#include <fstream>
#include <iostream>
using namespace std;

// dla wszystkich nazw plików przekazanych w charakterze argumentów z wiersza poleceń
// - otwórz, wyświetl zawartośc, oraz zamknij plik
int main (int argc, char* argv[])
{
    ifstream file;

    // dla wszystkich argumentów wiersza poleceń
    for (int i=1; i<argc; ++i) {

        // otwórz plik
        file.open(argv[i]);

        // zapisz zawartość pliku do strumienia cout
        char c;
        while (file.get(c)) {
            cout.put(c);
        }

        // zamknij plik
        file.close();
    }
}
