/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <locale>
#include <iostream>
#include <iomanip>
#include <exception>
#include <cstdlib>
using namespace std;

int main ()
{
    try {
        // use German locale:
#ifdef _MSC_VER
        locale locG("deu_deu.1252");
#else
        locale locG("de_DE");
#endif
        // użyj ustawień niemieckich z wypisywaniem symbolu waluty:
        cin.imbue(locG);
        cout.imbue(locG);
        cout << showbase;

        // wczytanie wartości pieniężnej do zmiennej typu long double (międzynarodowy skrót waluty)
        long double val;
        cout << "wartość pieniężna: ";
        cin >> get_money(val,true);

        if (cin) {
            // wypisz wartość pieniężną (lokalny symbol waluty)
            cout << put_money(val,false) << endl;
        }
        else {
            cerr << "niepoprawny format" << endl;
        }
    }
    catch (const std::exception& e) {
        cerr << "WYJĄTEK: " << e.what() << endl;
        return EXIT_FAILURE;
    }
}
