/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <list>
#include <algorithm>
#include <iterator>
#include "print.hpp"
using namespace std;

class IntSequence {
  private:
    int value;
  public:
    // konstruktor
    IntSequence (int initialValue)
     : value(initialValue) {
    }

    // "wywolanie funkcji"
    int operator() () {
        return ++value;
    }
};

int main()
{
    list<int> coll;
    IntSequence seq(1);    // ciag liczb calkowitych rozpoczynajacy sie od wartości 1

    // wstaw wartości od 1 do 4
    // - przekaz obiekt funkcyjny przez referencje
    // zeby generacja kontynuowana byla od wartości 5
    generate_n<back_insert_iterator<list<int>>,
               int, IntSequence&>(back_inserter(coll),    // początek
                                  4,      // liczba elementów
                                  seq);   // generuje wartości
    PRINT_ELEMENTS(coll);

    // wstaw wartości od 42 do 45
    generate_n (back_inserter(coll),      // początek
                4,                        // liczba elementów
                IntSequence(42));         // generuje wartości
    PRINT_ELEMENTS(coll);

    // kontynuuj z pierwszym ciagiem
    // - przekaz obiekt funkcyjny przez wartosc
    // zeby generacja ponownie kontynuowana byla od wartości 5
    generate_n (back_inserter(coll),      // początek
                4,                        // liczba elementów
                seq);                     // generuje wartości
    PRINT_ELEMENTS(coll);
    
    // ponownie kontynuuj z pierwszym ciagiem
    generate_n (back_inserter(coll),      // początek
                4,                        // liczba elementów
                seq);                     // generuje wartości
    PRINT_ELEMENTS(coll);
}

