/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <queue>
using namespace std;

int main()
{
    priority_queue<float> q;

    // wstaw do kolejki priorytetowej trzy elementy
    q.push(66.6);
    q.push(22.2);
    q.push(44.4);

    // odczytaj i wypisz dwa elementy
    cout << q.top() << ' ';
    q.pop();
    cout << q.top() << endl;
    q.pop();

    // wstaw kolejne trzy elementy
    q.push(11.1);
    q.push(55.5);
    q.push(33.3);

    // pomiń jeden element
    q.pop();

    // pobierz i wypisz pozostałe elementy
    while (!q.empty()) {
        cout << q.top() << ' ';
        q.pop();
    }
    cout << endl;
}

