/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <list>
#include <iostream>
#include <algorithm>
#include <iterator>
using namespace std;

void printLists (const list<int>& l1, const list<int>& l2)
{
    cout << "lista1: ";
    copy (l1.cbegin(), l1.cend(), ostream_iterator<int>(cout," "));
    cout << endl << "lista2: ";
    copy (l2.cbegin(), l2.cend(), ostream_iterator<int>(cout," "));
    cout << endl << endl;
}

int main()
{
    // utwórz dwie puste listy
    list<int> list1, list2;

    // wypełnij obydwie listy elementami
    for (int i=0; i<6; ++i) {
        list1.push_back(i);
        list2.push_front(i);
    }
    printLists(list1, list2);

    // wstaw wszystkie elementy kontenera list1 przed pierwszy element kontenera list2 o wartości 3
    // - algorytm find() zwraca iterator do pierwszego elementu o wartości 3
    list2.splice(find(list2.begin(),list2.end(),  // pozycja docelowa
                      3),
                 list1);                          // lista źródłowa
    printLists(list1, list2);

    // przenieś pierwszy element list2 na koniec
    list2.splice(list2.end(),        // pozycja docelowa
                 list2,              // lista źródłowa
                 list2.begin());     // pozycja źródłowa
    printLists(list1, list2);

    // posortuj drugą listę, przypisz do kontenera list1 i usuń powtórzenia
    list2.sort();
    list1 = list2;
    list2.unique();
    printLists(list1, list2);

    // scal obydwie posortowane listy w pierwszą listę
    list1.merge(list2);
    printLists(list1, list2);
}

