/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <atomic> // do obsługi typów atomowych
#include <future> // do wykorzystania funkcji async() i futur
#include <thread> // do wykorzystania klasy  this_thread
#include <chrono> // do zmiennych opisujących czas trwania
#include <iostream>

long data;
std::atomic<bool> readyFlag(false);

void provider ()
{
    // po odczytaniu znaku
    std::cout << "<return>" << std::endl;
    std::cin.get();

    // dostarczenie pewnych danych
data = 42;

    // zasygnalizowanie gotowości
    readyFlag.store(true);
}

void consumer ()
{
    // oczekiwanie na gotowość i wykonanie innej operacji
    while (!readyFlag.load()) {
        std::cout.put('.').flush();
        std::this_thread::sleep_for(std::chrono::milliseconds(500));
    }

    // przetwarzanie dostarczonych danych
    std::cout << "\nwartość : " << data << std::endl;
}

int main()
{
    // uruchomienie dostawcy i konsumenta
    auto p = std::async(std::launch::async,provider);
    auto c = std::async(std::launch::async,consumer);
}

