/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<int> coll;
    list<int> searchcoll;

    INSERT_ELEMENTS(coll,1,11);
    INSERT_ELEMENTS(searchcoll,3,5);

    PRINT_ELEMENTS(coll,      "coll:       ");
    PRINT_ELEMENTS(searchcoll,"searchcoll: ");

    // szukaj pierwszego wystapienia elementu kolekcji searchcoll w kolekcji coll
    vector<int>::iterator pos;
    pos = find_first_of (coll.begin(), coll.end(),     // zakres
                         searchcoll.begin(),   // poczatek zbioru wyszukiwanych elementow
                         searchcoll.end());    // koniec zbioru wyszukiwanych elementow
    cout << "pierwszym elementem kolekcji searchcoll w kolekcji coll jest element "
         << distance(coll.begin(),pos) + 1
         << endl;

    // szukaj ostatniego wystapienia elementu kolekcji searchcoll w kolekcji coll
    vector<int>::reverse_iterator rpos;
    rpos = find_first_of (coll.rbegin(), coll.rend(),  // zakres
                          searchcoll.begin(),  // poczatek zbioru wyszukiwanych elementow
                          searchcoll.end());   // koniec zbioru wyszukiwanych elementow
    cout << "ostatnim elementem kolekcji searchcoll w kolekcji coll jest element "
         << distance(coll.begin(),rpos.base())
         << endl;
}
