/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    list<int> coll;

    INSERT_ELEMENTS(coll,1,9);
    INSERT_ELEMENTS(coll,1,9);

    PRINT_ELEMENTS(coll,"coll: ");

    // znajdź pierwszy element o wartości 4
    list<int>::iterator pos1;
    pos1 = find (coll.begin(), coll.end(),    // zakres
                 4);                          // wartość

    // znajdź drugi element o wartości 4
    // - uwaga: kontynuuj wyszukiwanie za pierwszą 4-ką (o ile istnieje)
    list<int>::iterator pos2;
    if (pos1 != coll.end()) {
        pos2 = find (++pos1, coll.end(),      // zakres
                     4);                      // wartość
    }

    // wypisz wszystkie elementy od pierwszej do drugiej 4-ki (włącznie)
    // - uwaga: ponownie potrzebujemy pozycji pierwszej 4-ki (o ile istnieje)
    // - uwaga: musimy podać pozycję znajdującą się za drugą 4-ką (o ile istnieje)
    if (pos1!=coll.end() && pos2!=coll.end()) {
        copy (--pos1, ++pos2,
              ostream_iterator<int>(cout," "));
        cout << endl;
    }
}
