/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<string> coll1 = { "Ahoj", "to", "jest", "prosty", "przykład" };
    list<string> coll2;

    // kopiuj elementy kolekcji coll1 do coll2
    // - użyj wstawiacza końcowego, aby elementy były wstawiane a nie nadpisywane
    copy (coll1.cbegin(), coll1.cend(),         // zakres źrodłowy
          back_inserter(coll2));                // zakres docelowy

    // wypisz elementy kolekcji coll2
    // - copy elements to cout using an ostream iterator
    copy (coll2.cbegin(), coll2.cend(),         // zakres źrodłowy
          ostream_iterator<string>(cout," "));  // zakres docelowy
    cout << endl;

    // kopiuj elementy kolekcji coll1 do coll2 w odwrotnej kolejności
    // - teraz nadpisywanie
    copy (coll1.crbegin(), coll1.crend(),       // zakres źrodłowy
          coll2.begin());                       // zakres docelowy

    // ponownie wypisz elementy kolekcji coll2
    copy (coll2.cbegin(), coll2.cend(),         // zakres źrodłowy
          ostream_iterator<string>(cout," "));  // zakres docelowy
    cout << endl;
}
